package org.cadenhead.minecraft;

import java.util.logging.*;
import org.bukkit.*;
import org.bukkit.block.*;
import org.bukkit.command.*;
import org.bukkit.entity.*;
import org.bukkit.plugin.java.*;

public class IceCreamScoop extends JavaPlugin {
    public static final Logger log = Logger.getLogger("Minecraft");
    
    public boolean onCommand(CommandSender sender, Command command, 
        String label, String[] arguments) {

        // Ustaw domylny promie dou.
        double radius = 15;        
        if (arguments.length > 0) {
            try {
                // Odczytaj promie podany przez uytkownika (jeli zosta podany).
                radius = Double.parseDouble(arguments[0]);
                // Upewnij si, e ma dopuszczaln warto (5-25).
                if ((radius < 5) | (radius > 25)) {
                    radius = 15;
                }
            } catch (NumberFormatException exception) {
                // Nic nie rb (uyj ustawienia domylnego).
            }
        }
        
        if (label.equalsIgnoreCase("icecreamscoop")) { 
            if (sender instanceof Player) { 
                 scoopTerrain(sender, radius);
            }
            return true;
        }
        return false;
    }

    // Wykop okrgy d w wiecie.
    private void scoopTerrain(CommandSender sender, double rad) {
        Player me = (Player) sender;
        Location spot = me.getLocation();
        World world = me.getWorld();
       
        // Wykonaj ptle dla szecianw 3-D o bokach bdcych dwukrotnoci promienia
        for (double x = spot.getX() - rad; x < spot.getX() + rad; x++) {
            for (double y = spot.getY() - rad; y < spot.getY() + rad; y++) {
                for (double z = spot.getZ() - rad; z < spot.getZ() + rad; z++) {
                    // Pobierz lokalizacj w tym kwadracie
                    Location loc = new Location(world, x, y, z);
                    // Sprawd, jak daleko znajduje si gracz
                    double xd = x - spot.getX();
                    double yd = y - spot.getY();
                    double zd = z - spot.getZ();
                    double distance = Math.sqrt(xd * xd + yd * yd + zd * zd);
                    // Czy mieci si w promieniu?
                    if (distance < rad) {
                        // Jeli tak, to zmie ten blok w powietrze
                        Block current = world.getBlockAt(loc);
                        current.setType(Material.AIR);
                    }
                }
            }
        }
       
        // Odtwrz dwik po wykopaniu dou
        world.playSound(spot, Sound.BURP, 30, 5);
        log.info("[IceCreamScoop] Wykopano d w miejscu ("
            + spot.getX() + ","
            + spot.getY() + ","
            + spot.getZ() + ")");
    }
}
